/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.core.project.options.includepath;

import com.aptana.core.util.CollectionsUtil;
import com.aptana.editor.php.epl.PHPEplPlugin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org2.eclipse.php.internal.core.project.options.includepath.IncludePathVariablesListener;

public class IncludePathVariableManager {
    private static final String COMMA = ",";
    private static IncludePathVariableManager instance;
    IPreferenceStore preferenceStore = PHPEplPlugin.getDefault().getPreferenceStore();
    private Map<String, IPath> variables = new HashMap<String, IPath>();
    private Set<String> reservedVariables = new HashSet<String>();
    private List<IncludePathVariablesListener> listeners;

    public static IncludePathVariableManager instance() {
        if (instance == null) {
            instance = new IncludePathVariableManager();
        }
        return instance;
    }

    private IncludePathVariableManager() {
    }

    public IPath getIncludePathVariable(String variableName) {
        IPath varPath = null;
        Path path = new Path(variableName);
        if (path.segmentCount() == 1) {
            varPath = this.variables.get(variableName);
        } else {
            varPath = this.variables.get(path.segment(0));
            if (varPath != null) {
                varPath = varPath.append(path.removeFirstSegments(1));
            }
        }
        return varPath;
    }

    public void setIncludePathVariables(String[] names, IPath[] paths, SubProgressMonitor monitor) {
        this.variables.clear();
        StringBuffer namesString = new StringBuffer();
        StringBuffer pathsString = new StringBuffer();
        int i = 0;
        while (i < names.length) {
            if (paths[i] != null) {
                this.variables.put(names[i], paths[i]);
                if (i > 0) {
                    namesString.append(COMMA);
                    pathsString.append(COMMA);
                }
                namesString.append(names[i]);
                pathsString.append(paths[i].toOSString());
            }
            ++i;
        }
        this.preferenceStore.setValue("com.aptana.editor.php.epl.includePathVariableNames", namesString.toString());
        this.preferenceStore.setValue("com.aptana.editor.php.epl.includePathVariablePaths", pathsString.toString());
        this.fireIncludePathVariablesChanged(names, paths);
    }

    private void fireIncludePathVariablesChanged(String[] names, IPath[] paths) {
        if (CollectionsUtil.isEmpty(this.listeners)) {
            return;
        }
        for (IncludePathVariablesListener listener : this.listeners) {
            listener.includePathVariablesChanged(names, paths);
        }
    }

    public void addListener(IncludePathVariablesListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<IncludePathVariablesListener>(1);
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(IncludePathVariablesListener listener) {
        if (CollectionsUtil.isEmpty(this.listeners)) {
            return;
        }
        this.listeners.remove(listener);
    }

    public String[] getIncludePathVariableNames() {
        return this.variables.keySet().toArray(new String[this.variables.size()]);
    }

    public void startUp() {
        String namesString = this.preferenceStore.getString("com.aptana.editor.php.epl.includePathVariableNames");
        String pathsString = this.preferenceStore.getString("com.aptana.editor.php.epl.includePathVariablePaths");
        String[] names = new String[]{};
        if (namesString.length() > 0) {
            names = namesString.split(COMMA);
        }
        String[] paths = new String[]{};
        if (pathsString.length() > 0) {
            paths = pathsString.split(COMMA);
        }
        int i = 0;
        while (i < names.length) {
            String path = i < paths.length ? paths[i] : "";
            this.variables.put(names[i], (IPath)new Path(path));
            ++i;
        }
        this.initExtensionPoints();
    }

    private void initExtensionPoints() {
        IConfigurationElement[] elements;
        PHPEplPlugin phpCorePlugin = PHPEplPlugin.getDefault();
        if (phpCorePlugin == null) {
            return;
        }
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor("com.aptana.editor.php.epl", "includePathVariables");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if ("variable".equals(element.getName())) {
                String name = element.getAttribute("name");
                String value = element.getAttribute("value");
                if (value != null) {
                    this.putVariable(name, (IPath)new Path(value));
                    this.reservedVariables.add(name);
                }
            }
            ++n2;
        }
    }

    public synchronized void putVariable(String name, IPath path) {
        this.variables.put(name, path);
    }

    public boolean isReserved(String variableName) {
        return this.reservedVariables.contains(variableName);
    }

    public String[] getReservedVariables() {
        return this.reservedVariables.toArray(new String[this.reservedVariables.size()]);
    }

    public IPath resolveVariablePath(String path) {
        int index = path.indexOf(47);
        if (index != -1) {
            String var = path.substring(0, index);
            IPath varPath = this.getIncludePathVariable(var);
            if (varPath != null && index + 1 < path.length()) {
                varPath = varPath.append(path.substring(index + 1));
            }
            return varPath;
        }
        return this.getIncludePathVariable(path);
    }
}

